/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class VWModalDialog
extends JDialog
implements IVWFrameInterface {
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    private boolean m_bFrameSizeAdjusted = false;
    private VWWindowAdapter m_windowListener = null;
    protected Container m_parent = null;
    protected int m_nExitStatus = -1;

    public VWModalDialog(Frame parent) {
        super(parent, true);
        this.m_parent = parent;
        this.m_windowListener = new VWWindowAdapter(this);
        this.addWindowListener(this.m_windowListener);
    }

    public VWModalDialog(Dialog parent) {
        super(parent, true);
        this.m_parent = parent;
        this.m_windowListener = new VWWindowAdapter(this);
        this.addWindowListener(this.m_windowListener);
    }

    public static Frame getParentFrameUsingContainer(Container parentContainer) {
        Frame parentFrame = JOptionPane.getFrameForComponent(parentContainer);
        if (parentFrame != null) {
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            parentFrame.applyComponentOrientation(compOrientation);
        }
        return parentFrame;
    }

    public final void show() {
        this.updateComponentOrientation();
        Container parent = this.getParent();
        if (parent != null && (parent instanceof JFrame || parent instanceof JDialog)) {
            this.setLocationRelativeTo(parent);
        } else {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenDim.width - this.getWidth()) / 2, (screenDim.height - this.getHeight()) / 2);
        }
        super.show();
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.m_bFrameSizeAdjusted) {
            return;
        }
        this.m_bFrameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    public void removeReferences() {
        this.m_parent = null;
        if (this.m_windowListener != null) {
            this.removeWindowListener(this.m_windowListener);
            this.m_windowListener = null;
        }
    }

    public int getExitStatus() {
        return this.m_nExitStatus;
    }

    public void windowClosing(WindowEvent event) {
        this.m_nExitStatus = 1;
        this.setVisible(false);
    }

    private void updateComponentOrientation() {
        try {
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(compOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

